@extends('layouts.app')

@section('title', 'Support Tickets')
@section('page-title', 'Support')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-life-ring mr-2"></i>My Support Tickets</h3>
                    <div class="card-tools">
                        <a href="{{ route('support.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus mr-1"></i>New Ticket
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    @if($tickets->count() > 0)
                        <table class="table table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Ticket #</th>
                                    <th>Subject</th>
                                    <th>Category</th>
                                    <th>Status</th>
                                    <th>Last Update</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tickets as $ticket)
                                    <tr>
                                        <td><code>{{ $ticket->ticket_number }}</code></td>
                                        <td>
                                            <a href="{{ route('support.show', $ticket) }}">
                                                {{ Str::limit($ticket->subject, 40) }}
                                            </a>
                                        </td>
                                        <td>
                                            <i class="{{ $ticket->category_icon }} mr-1"></i>
                                            {{ ucfirst($ticket->category) }}
                                        </td>
                                        <td>
                                            <span class="badge {{ $ticket->status_badge }}">
                                                {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                                            </span>
                                        </td>
                                        <td>{{ $ticket->last_reply_at?->diffForHumans() ?? $ticket->created_at->diffForHumans() }}</td>
                                        <td>
                                            <a href="{{ route('support.show', $ticket) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-ticket-alt fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No support tickets yet.</p>
                            <a href="{{ route('support.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus mr-1"></i>Create Your First Ticket
                            </a>
                        </div>
                    @endif
                </div>
                @if($tickets->hasPages())
                    <div class="card-footer">
                        {{ $tickets->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
