@extends('layouts.app')

@section('title', 'Ticket ' . $ticket->ticket_number)
@section('page-title', 'View Ticket')

@section('content')
    <div class="row">
        <div class="col-md-8">
            <!-- Ticket Info -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="{{ $ticket->category_icon }} mr-2"></i>
                        {{ $ticket->subject }}
                    </h3>
                    <div class="card-tools">
                        <span class="badge {{ $ticket->status_badge }}">
                            {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                        </span>
                        <span class="badge {{ $ticket->priority_badge }} ml-1">
                            {{ ucfirst($ticket->priority) }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Messages -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-comments mr-2"></i>Conversation</h3>
                </div>
                <div class="card-body" style="max-height: 500px; overflow-y: auto;">
                    @foreach($ticket->messages as $message)
                        <div class="direct-chat-msg {{ $message->is_admin_reply ? 'right' : '' }} mb-3">
                            <div class="direct-chat-infos clearfix">
                                <span class="direct-chat-name {{ $message->is_admin_reply ? 'float-right' : 'float-left' }}">
                                    {{ $message->user->name }}
                                    @if($message->is_admin_reply)
                                        <span class="badge badge-primary">Support</span>
                                    @endif
                                </span>
                                <span class="direct-chat-timestamp {{ $message->is_admin_reply ? 'float-left' : 'float-right' }}">
                                    {{ $message->created_at->format('M d, Y h:i A') }}
                                </span>
                            </div>
                            <div class="direct-chat-text {{ $message->is_admin_reply ? 'bg-primary' : 'bg-light' }}" 
                                 style="{{ $message->is_admin_reply ? '' : 'color: #333;' }}">
                                {!! nl2br(e($message->message)) !!}
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Reply Form -->
            @if(!in_array($ticket->status, ['closed', 'resolved']))
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-reply mr-2"></i>Reply</h3>
                    </div>
                    <form action="{{ route('support.reply', $ticket) }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="form-group mb-0">
                                <textarea name="message" class="form-control" rows="4" 
                                          placeholder="Type your reply..." required></textarea>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane mr-1"></i>Send Reply
                            </button>
                        </div>
                    </form>
                </div>
            @else
                <div class="alert alert-secondary">
                    <i class="fas fa-lock mr-2"></i>
                    This ticket has been {{ $ticket->status }}. You cannot add more replies.
                </div>
            @endif
        </div>

        <div class="col-md-4">
            <!-- Ticket Details -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-info-circle mr-2"></i>Ticket Details</h3>
                </div>
                <div class="card-body p-0">
                    <table class="table table-sm mb-0">
                        <tr>
                            <td class="text-muted">Ticket #</td>
                            <td><code>{{ $ticket->ticket_number }}</code></td>
                        </tr>
                        <tr>
                            <td class="text-muted">Category</td>
                            <td>
                                <i class="{{ $ticket->category_icon }} mr-1"></i>
                                {{ ucfirst($ticket->category) }}
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Priority</td>
                            <td>
                                <span class="badge {{ $ticket->priority_badge }}">
                                    {{ ucfirst($ticket->priority) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Status</td>
                            <td>
                                <span class="badge {{ $ticket->status_badge }}">
                                    {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Created</td>
                            <td>{{ $ticket->created_at->format('M d, Y') }}</td>
                        </tr>
                        <tr>
                            <td class="text-muted">Last Update</td>
                            <td>{{ $ticket->last_reply_at?->diffForHumans() ?? 'N/A' }}</td>
                        </tr>
                        @if($ticket->assignedTo)
                            <tr>
                                <td class="text-muted">Assigned To</td>
                                <td>{{ $ticket->assignedTo->name }}</td>
                            </tr>
                        @endif
                    </table>
                </div>
            </div>

            <!-- Actions -->
            @if(!in_array($ticket->status, ['closed']))
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-cog mr-2"></i>Actions</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('support.close', $ticket) }}" method="POST" 
                              onsubmit="return confirm('Close this ticket?')">
                            @csrf
                            <button type="submit" class="btn btn-secondary btn-block">
                                <i class="fas fa-times-circle mr-1"></i>Close Ticket
                            </button>
                        </form>
                    </div>
                </div>
            @endif

            <a href="{{ route('support.index') }}" class="btn btn-outline-secondary btn-block">
                <i class="fas fa-arrow-left mr-1"></i>Back to Tickets
            </a>
        </div>
    </div>
@endsection
