<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Updit - Automated Video Publishing</title>
    <meta name="description" content="Automate your YouTube publishing. Upload once, schedule, and let Updit handle the rest.">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    
    <style>
        :root {
            --primary: #8b5cf6;
            --primary-dark: #7c3aed;
            --secondary: #6366f1;
            --dark: #0f0c29;
            --darker: #030014;
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--darker);
            color: #fff;
            overflow-x: hidden;
        }
        
        .container { max-width: 1200px; margin: 0 auto; padding: 0 24px; }
        
        /* Animations */
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
        
        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        .float { animation: float 6s ease-in-out infinite; }
        
        /* Header */
        header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            padding: 16px 0;
            background: rgba(3, 0, 20, 0.8);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(139, 92, 246, 0.1);
            transition: all 0.3s;
        }
        
        header.scrolled {
            padding: 12px 0;
            background: rgba(3, 0, 20, 0.95);
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            display: flex;
            align-items: center;
            font-size: 1.75rem;
            font-weight: 800;
            text-decoration: none;
            color: #fff;
            gap: 10px;
        }
        
        .logo-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }
        
        .logo-text {
            background: linear-gradient(135deg, #fff 0%, #a5b4fc 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        nav {
            display: flex;
            gap: 32px;
            align-items: center;
        }
        
        nav a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            font-weight: 500;
            font-size: 0.95rem;
            transition: all 0.3s;
            position: relative;
        }
        
        nav a:hover { color: #fff; }
        
        nav a::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary);
            transition: width 0.3s;
        }
        
        nav a:hover::after { width: 100%; }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 28px;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 0.95rem;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            color: #fff;
            box-shadow: 0 4px 20px rgba(139, 92, 246, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 30px rgba(139, 92, 246, 0.5);
        }
        
        .btn-outline {
            background: transparent;
            border: 2px solid rgba(255,255,255,0.2);
            color: #fff;
        }
        
        .btn-outline:hover {
            border-color: var(--primary);
            background: rgba(139, 92, 246, 0.1);
        }
        
        .mobile-menu {
            display: none;
            font-size: 1.5rem;
            color: #fff;
            cursor: pointer;
        }
        
        /* Hero */
        .hero {
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 120px 0 80px;
            background: radial-gradient(ellipse at top, rgba(139, 92, 246, 0.15) 0%, transparent 50%);
            position: relative;
            overflow: hidden;
        }
        
        .hero::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 800px;
            height: 800px;
            background: radial-gradient(circle, rgba(139, 92, 246, 0.1) 0%, transparent 70%);
            pointer-events: none;
        }
        
        .hero-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
        }
        
        .hero-content { z-index: 1; }
        
        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            background: rgba(139, 92, 246, 0.2);
            border-radius: 50px;
            font-size: 0.85rem;
            margin-bottom: 24px;
            border: 1px solid rgba(139, 92, 246, 0.3);
        }
        
        .hero-badge i { color: var(--primary); }
        
        .hero h1 {
            font-size: 3.5rem;
            font-weight: 800;
            line-height: 1.1;
            margin-bottom: 24px;
        }
        
        .hero h1 .gradient {
            background: linear-gradient(135deg, var(--secondary), var(--primary), #ec4899);
            background-size: 200% 200%;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            animation: gradient 5s ease infinite;
        }
        
        .hero p {
            font-size: 1.15rem;
            color: rgba(255,255,255,0.7);
            line-height: 1.7;
            margin-bottom: 36px;
            max-width: 500px;
        }
        
        .hero-buttons {
            display: flex;
            gap: 16px;
            flex-wrap: wrap;
        }
        
        .hero-image {
            position: relative;
            z-index: 1;
        }
        
        .hero-image img {
            width: 100%;
            max-width: 550px;
            border-radius: 20px;
        }
        
        .hero-stats {
            display: flex;
            gap: 40px;
            margin-top: 50px;
        }
        
        .stat {
            text-align: left;
        }
        
        .stat-number {
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary);
        }
        
        .stat-label {
            font-size: 0.9rem;
            color: rgba(255,255,255,0.6);
        }
        
        /* How It Works */
        .how-it-works {
            padding: 120px 0;
            background: linear-gradient(180deg, var(--darker) 0%, var(--dark) 100%);
        }
        
        .section-header {
            text-align: center;
            margin-bottom: 80px;
        }
        
        .section-label {
            display: inline-block;
            padding: 8px 20px;
            background: rgba(139, 92, 246, 0.2);
            border-radius: 50px;
            font-size: 0.85rem;
            font-weight: 600;
            color: var(--primary);
            margin-bottom: 16px;
        }
        
        .section-header h2 {
            font-size: 2.75rem;
            font-weight: 700;
            margin-bottom: 16px;
        }
        
        .section-header p {
            color: rgba(255,255,255,0.6);
            font-size: 1.1rem;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .steps-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 30px;
        }
        
        .step-card {
            background: rgba(255,255,255,0.03);
            border: 1px solid rgba(255,255,255,0.08);
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            position: relative;
            transition: all 0.4s;
        }
        
        .step-card:hover {
            transform: translateY(-10px);
            background: rgba(139, 92, 246, 0.1);
            border-color: rgba(139, 92, 246, 0.3);
        }
        
        .step-number {
            position: absolute;
            top: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 30px;
            height: 30px;
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 0.85rem;
        }
        
        .step-icon {
            width: 80px;
            height: 80px;
            background: rgba(139, 92, 246, 0.15);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: var(--primary);
            margin: 0 auto 24px;
        }
        
        .step-card h3 {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 12px;
        }
        
        .step-card p {
            color: rgba(255,255,255,0.6);
            font-size: 0.95rem;
            line-height: 1.6;
        }
        
        /* Features */
        .features {
            padding: 120px 0;
            background: var(--dark);
        }
        
        .feature-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
        }
        
        .feature-card {
            background: rgba(255,255,255,0.03);
            border: 1px solid rgba(255,255,255,0.08);
            border-radius: 20px;
            padding: 40px;
            transition: all 0.4s;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            border-color: rgba(139, 92, 246, 0.3);
            background: rgba(139, 92, 246, 0.05);
        }
        
        .feature-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 24px;
        }
        
        .feature-card h3 {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 12px;
        }
        
        .feature-card p {
            color: rgba(255,255,255,0.6);
            line-height: 1.7;
        }
        
        /* Pricing */
        .pricing {
            padding: 120px 0;
            background: linear-gradient(180deg, var(--dark) 0%, var(--darker) 100%);
        }
        
        .pricing-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
            max-width: 1000px;
            margin: 0 auto;
        }
        
        .price-card {
            background: rgba(255,255,255,0.03);
            border: 1px solid rgba(255,255,255,0.08);
            border-radius: 24px;
            padding: 40px;
            text-align: center;
            transition: all 0.4s;
            position: relative;
        }
        
        .price-card.featured {
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.15), rgba(99, 102, 241, 0.15));
            border-color: rgba(139, 92, 246, 0.4);
            transform: scale(1.05);
        }
        
        .price-card.featured::before {
            content: 'POPULAR';
            position: absolute;
            top: -12px;
            left: 50%;
            transform: translateX(-50%);
            padding: 6px 20px;
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            border-radius: 50px;
            font-size: 0.75rem;
            font-weight: 700;
        }
        
        .price-card h3 {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 8px;
        }
        
        .price {
            font-size: 3rem;
            font-weight: 800;
            margin: 20px 0;
        }
        
        .price span {
            font-size: 1rem;
            font-weight: 400;
            color: rgba(255,255,255,0.5);
        }
        
        .price-features {
            list-style: none;
            margin: 30px 0;
            text-align: left;
        }
        
        .price-features li {
            padding: 12px 0;
            border-bottom: 1px solid rgba(255,255,255,0.05);
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 0.95rem;
        }
        
        .price-features li i {
            color: #10b981;
            font-size: 0.9rem;
        }
        
        /* Footer */
        footer {
            padding: 80px 0 40px;
            background: var(--darker);
            border-top: 1px solid rgba(255,255,255,0.05);
        }
        
        .footer-grid {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 60px;
            margin-bottom: 60px;
        }
        
        .footer-brand p {
            color: rgba(255,255,255,0.6);
            margin-top: 16px;
            font-size: 0.95rem;
            line-height: 1.7;
        }
        
        .footer-links h4 {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 20px;
        }
        
        .footer-links a {
            display: block;
            color: rgba(255,255,255,0.6);
            text-decoration: none;
            padding: 8px 0;
            font-size: 0.95rem;
            transition: color 0.3s;
        }
        
        .footer-links a:hover { color: var(--primary); }
        
        .social-links {
            display: flex;
            gap: 12px;
            margin-top: 20px;
        }
        
        .social-links a {
            width: 42px;
            height: 42px;
            background: rgba(255,255,255,0.05);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            transition: all 0.3s;
        }
        
        .social-links a:hover {
            background: var(--primary);
            transform: translateY(-3px);
        }
        
        .footer-bottom {
            padding-top: 40px;
            border-top: 1px solid rgba(255,255,255,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: rgba(255,255,255,0.5);
            font-size: 0.9rem;
        }
        
        /* Responsive */
        @media (max-width: 1024px) {
            .hero-grid { grid-template-columns: 1fr; text-align: center; }
            .hero-content { order: 1; }
            .hero-image { order: 0; }
            .hero p { margin-left: auto; margin-right: auto; }
            .hero-buttons { justify-content: center; }
            .hero-stats { justify-content: center; }
            .steps-grid { grid-template-columns: repeat(2, 1fr); }
            .feature-grid { grid-template-columns: repeat(2, 1fr); }
            .pricing-grid { grid-template-columns: 1fr; max-width: 400px; }
            .price-card.featured { transform: scale(1); }
            .footer-grid { grid-template-columns: 1fr 1fr; }
        }
        
        @media (max-width: 768px) {
            .hero h1 { font-size: 2.5rem; }
            nav { display: none; }
            .mobile-menu { display: block; }
            .steps-grid { grid-template-columns: 1fr; }
            .feature-grid { grid-template-columns: 1fr; }
            .footer-grid { grid-template-columns: 1fr; }
            .footer-bottom { flex-direction: column; gap: 16px; text-align: center; }
        }
    </style>
</head>
<body>
    <header id="header">
        <div class="container header-content">
            <a href="/" class="logo">
                <div class="logo-icon"><i class="fas fa-upload"></i></div>
                <span class="logo-text">Updit</span>
            </a>
            <nav>
                <a href="#features">Features</a>
                <a href="#how-it-works">How It Works</a>
                <a href="#pricing">Pricing</a>
                <a href="{{ route('login') }}" class="btn btn-outline">Login</a>
                <a href="{{ route('register') }}" class="btn btn-primary">Get Started</a>
            </nav>
            <div class="mobile-menu"><i class="fas fa-bars"></i></div>
        </div>
    </header>

    <section class="hero">
        <div class="container">
            <div class="hero-grid">
                <div class="hero-content animate__animated animate__fadeInLeft">
                    <div class="hero-badge">
                        <i class="fas fa-bolt"></i>
                        <span>Now with YouTube Shorts Support</span>
                    </div>
                    <h1>Automate Your <span class="gradient">YouTube Publishing</span></h1>
                    <p>Upload once, schedule smart, and let Updit publish your videos automatically. Save hours every week with intelligent scheduling and quota management.</p>
                    <div class="hero-buttons">
                        <a href="{{ route('register') }}" class="btn btn-primary">
                            <i class="fas fa-rocket"></i> Start Free
                        </a>
                        <a href="#how-it-works" class="btn btn-outline">
                            <i class="fas fa-play-circle"></i> See How It Works
                        </a>
                    </div>
                    <div class="hero-stats">
                        <div class="stat">
                            <div class="stat-number">10K+</div>
                            <div class="stat-label">Videos Published</div>
                        </div>
                        <div class="stat">
                            <div class="stat-number">500+</div>
                            <div class="stat-label">Happy Creators</div>
                        </div>
                        <div class="stat">
                            <div class="stat-number">99.9%</div>
                            <div class="stat-label">Uptime</div>
                        </div>
                    </div>
                </div>
                <div class="hero-image animate__animated animate__fadeInRight">
                    <img src="/images/hero-illustration.png" alt="Updit Platform" class="float" onerror="this.style.display='none'">
                </div>
            </div>
        </div>
    </section>

    <section class="how-it-works" id="how-it-works">
        <div class="container">
            <div class="section-header">
                <div class="section-label">HOW IT WORKS</div>
                <h2>Get Started in 4 Simple Steps</h2>
                <p>From upload to publish, we've made every step effortless</p>
            </div>
            <div class="steps-grid">
                <div class="step-card">
                    <div class="step-number">1</div>
                    <div class="step-icon"><i class="fas fa-link"></i></div>
                    <h3>Connect Channel</h3>
                    <p>Securely link your YouTube account with OAuth 2.0 authentication</p>
                </div>
                <div class="step-card">
                    <div class="step-number">2</div>
                    <div class="step-icon"><i class="fas fa-cloud-upload-alt"></i></div>
                    <h3>Upload Videos</h3>
                    <p>Drag and drop your videos. Add titles, descriptions, and tags</p>
                </div>
                <div class="step-card">
                    <div class="step-number">3</div>
                    <div class="step-icon"><i class="fas fa-calendar-alt"></i></div>
                    <h3>Set Schedule</h3>
                    <p>Choose your interval - from every 30 minutes to daily uploads</p>
                </div>
                <div class="step-card">
                    <div class="step-number">4</div>
                    <div class="step-icon"><i class="fas fa-rocket"></i></div>
                    <h3>Sit Back & Relax</h3>
                    <p>Watch your videos publish automatically while you focus on creating</p>
                </div>
            </div>
        </div>
    </section>

    <section class="features" id="features">
        <div class="container">
            <div class="section-header">
                <div class="section-label">FEATURES</div>
                <h2>Everything You Need</h2>
                <p>Powerful tools designed for content creators</p>
            </div>
            <div class="feature-grid">
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-clock"></i></div>
                    <h3>Smart Scheduling</h3>
                    <p>Set custom intervals between uploads. Perfect for drip-feeding content to your audience.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-mobile-alt"></i></div>
                    <h3>Shorts Mode</h3>
                    <p>Automatically optimize your videos for YouTube Shorts with a single toggle.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-sync-alt"></i></div>
                    <h3>Smart Restart</h3>
                    <p>Hit quota limits? We automatically pause and resume after 24 hours.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-layer-group"></i></div>
                    <h3>Multi-Channel</h3>
                    <p>Manage multiple YouTube channels from a single, unified dashboard.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-shield-alt"></i></div>
                    <h3>Bank-Level Security</h3>
                    <p>OAuth tokens are encrypted. Your data stays private and secure.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-chart-line"></i></div>
                    <h3>Real-time Progress</h3>
                    <p>Track every upload with live progress bars and detailed logs.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="pricing" id="pricing">
        <div class="container">
            <div class="section-header">
                <div class="section-label">PRICING</div>
                <h2>Simple, Transparent Pricing</h2>
                <p>Choose the plan that fits your needs. Upgrade anytime.</p>
            </div>
            <div class="pricing-grid">
                <div class="price-card">
                    <h3>Free</h3>
                    <div class="price">$0 <span>/month</span></div>
                    <ul class="price-features">
                        <li><i class="fas fa-check"></i> 5 videos per batch</li>
                        <li><i class="fas fa-check"></i> 30 min minimum interval</li>
                        <li><i class="fas fa-check"></i> 10 uploads per day</li>
                        <li><i class="fas fa-check"></i> 1 YouTube channel</li>
                    </ul>
                    <a href="{{ route('register') }}" class="btn btn-outline" style="width: 100%;">Get Started</a>
                </div>
                <div class="price-card featured">
                    <h3>Pro</h3>
                    <div class="price">$19 <span>/month</span></div>
                    <ul class="price-features">
                        <li><i class="fas fa-check"></i> 25 videos per batch</li>
                        <li><i class="fas fa-check"></i> 15 min minimum interval</li>
                        <li><i class="fas fa-check"></i> 50 uploads per day</li>
                        <li><i class="fas fa-check"></i> 3 YouTube channels</li>
                        <li><i class="fas fa-check"></i> Priority support</li>
                    </ul>
                    <a href="{{ route('register') }}" class="btn btn-primary" style="width: 100%;">Start Free Trial</a>
                </div>
                <div class="price-card">
                    <h3>Agency</h3>
                    <div class="price">$49 <span>/month</span></div>
                    <ul class="price-features">
                        <li><i class="fas fa-check"></i> 50 videos per batch</li>
                        <li><i class="fas fa-check"></i> 5 min minimum interval</li>
                        <li><i class="fas fa-check"></i> Unlimited uploads/day</li>
                        <li><i class="fas fa-check"></i> Unlimited channels</li>
                        <li><i class="fas fa-check"></i> API access</li>
                    </ul>
                    <a href="{{ route('register') }}" class="btn btn-outline" style="width: 100%;">Contact Sales</a>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <a href="/" class="logo">
                        <div class="logo-icon"><i class="fas fa-upload"></i></div>
                        <span class="logo-text">Updit</span>
                    </a>
                    <p>Automate your YouTube publishing workflow. Upload once, schedule smart, and focus on what matters - creating great content.</p>
                    <div class="social-links">
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>
                <div class="footer-links">
                    <h4>Product</h4>
                    <a href="#features">Features</a>
                    <a href="#pricing">Pricing</a>
                    <a href="#how-it-works">How It Works</a>
                </div>
                <div class="footer-links">
                    <h4>Company</h4>
                    <a href="/about">About Us</a>
                    <a href="/contact">Contact</a>
                    <a href="/blog">Blog</a>
                </div>
                <div class="footer-links">
                    <h4>Legal</h4>
                    <a href="/privacy">Privacy Policy</a>
                    <a href="/terms">Terms of Service</a>
                    <a href="/cookies">Cookie Policy</a>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; {{ date('Y') }} Updit. All rights reserved.</p>
                <p style="color: rgba(255,255,255,0.4); font-size: 0.85rem;">
                    Designed by <a href="https://wa.me/2349035026516" target="_blank" style="color: #10b981; text-decoration: none;">Ogasmantechs</a> 
                    | <a href="https://wa.me/2349035026516" target="_blank" style="color: #10b981; text-decoration: none;"><i class="fab fa-whatsapp"></i> +234 903 502 6516</a>
                </p>
            </div>
        </div>
    </footer>

    <script>
        // Header scroll effect
        window.addEventListener('scroll', function() {
            const header = document.getElementById('header');
            if (window.scrollY > 50) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        });
        
        // Smooth scroll
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            });
        });
    </script>
</body>
</html>
