<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

/*
|--------------------------------------------------------------------------
| Console Routes & Scheduled Tasks
|--------------------------------------------------------------------------
*/

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

/*
|--------------------------------------------------------------------------
| Scheduled Tasks for Updit
|--------------------------------------------------------------------------
*/

// Run the scheduler every minute to process video uploads
Schedule::command('updit:run-schedule')->everyMinute();

// Check for schedules to resume every hour
Schedule::command('updit:resume-schedules')->hourly();

// Clean up old logs weekly
Schedule::command('queue:prune-failed --hours=168')->weekly();
