

<?php $__env->startSection('title', 'Upload Logs'); ?>
<?php $__env->startSection('page-title', 'Upload Logs'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Upload Logs</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-history mr-2"></i>Recent Upload Activity</h3>
        </div>
        <div class="card-body p-0">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>User</th>
                        <th>Video</th>
                        <th>Status</th>
                        <th>Message</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($log->created_at->format('M d, H:i:s')); ?></td>
                            <td>
                                <?php if($log->user): ?>
                                    <a href="<?php echo e(route('admin.users.edit', $log->user)); ?>">
                                        <?php echo e($log->user->name); ?>

                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">Deleted</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($log->video): ?>
                                    <?php echo e(Str::limit($log->video->title, 30)); ?>

                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge <?php echo e($log->status_badge); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $log->status))); ?>

                                </span>
                            </td>
                            <td><?php echo e(Str::limit($log->message, 50)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center p-5">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted mb-0">No upload logs yet.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($logs->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($logs->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views\admin\system\logs.blade.php ENDPATH**/ ?>