

<?php $__env->startSection('title', 'Manage Plans'); ?>
<?php $__env->startSection('page-title', 'Subscription Plans'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Plans</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-crown mr-2"></i>All Plans</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('admin.plans.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus mr-2"></i>Create New Plan
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover table-striped">
                        <thead>
                            <tr>
                                <th>Plan Name</th>
                                <th>Price</th>
                                <th>Videos/Batch</th>
                                <th>Min Interval</th>
                                <th>Daily Cap</th>
                                <th>Users</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($plan->name); ?></strong>
                                        <?php if($plan->price == 0): ?>
                                            <span class="badge badge-success ml-2">Free</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($plan->price > 0): ?>
                                            <span class="text-success font-weight-bold">$<?php echo e(number_format($plan->price, 2)); ?>/mo</span>
                                        <?php else: ?>
                                            <span class="text-muted">Free</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($plan->max_videos_per_batch); ?></td>
                                    <td><?php echo e($plan->min_interval_minutes); ?> min</td>
                                    <td><?php echo e($plan->daily_upload_cap); ?> videos</td>
                                    <td>
                                        <span class="badge badge-info"><?php echo e($plan->users_count); ?> users</span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('admin.plans.edit', $plan)); ?>" class="btn btn-info" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <?php if($plan->users_count == 0): ?>
                                                <form action="<?php echo e(route('admin.plans.destroy', $plan)); ?>" method="POST" class="d-inline"
                                                      onsubmit="return confirm('Delete this plan?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Plan Features Summary -->
    <div class="row">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4">
                <div class="card card-outline <?php echo e($plan->price == 0 ? 'card-secondary' : ($plan->price > 30 ? 'card-warning' : 'card-primary')); ?>">
                    <div class="card-header text-center">
                        <h3 class="card-title"><?php echo e($plan->name); ?></h3>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="mb-0">
                            <?php if($plan->price > 0): ?>
                                $<?php echo e(number_format($plan->price, 0)); ?>

                            <?php else: ?>
                                Free
                            <?php endif; ?>
                        </h1>
                        <?php if($plan->price > 0): ?>
                            <small class="text-muted">per month</small>
                        <?php endif; ?>
                        
                        <hr>
                        
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success mr-2"></i><?php echo e($plan->max_videos_per_batch); ?> videos per batch</li>
                            <li><i class="fas fa-check text-success mr-2"></i><?php echo e($plan->min_interval_minutes); ?> min minimum interval</li>
                            <li><i class="fas fa-check text-success mr-2"></i><?php echo e($plan->daily_upload_cap); ?> daily uploads</li>
                            <?php if($plan->features && is_array($plan->features)): ?>
                                <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><i class="fas fa-check text-success mr-2"></i><?php echo e($feature); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                        
                        <div class="mt-3">
                            <span class="badge badge-info"><?php echo e($plan->users_count); ?> active users</span>
                        </div>
                    </div>
                    <div class="card-footer text-center">
                        <a href="<?php echo e(route('admin.plans.edit', $plan)); ?>" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-edit mr-1"></i>Edit Plan
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/admin/plans/index.blade.php ENDPATH**/ ?>