<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(route('dashboard')); ?>" class="brand-link text-center">
        <i class="fas fa-upload brand-image" style="font-size: 1.5rem; margin-left: 0.8rem; color: #8b5cf6;"></i>
        <span class="brand-text font-weight-bold">Updit</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <i class="fas fa-user-circle fa-2x text-light"></i>
            </div>
            <div class="info">
                <a href="#" class="d-block"><?php echo e(Auth::user()->name ?? 'Guest'); ?></a>
                <small class="text-muted">
                    <?php if(Auth::check() && Auth::user()->plan): ?>
                        <span class="badge badge-info"><?php echo e(Auth::user()->plan->name); ?></span>
                    <?php endif; ?>
                </small>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                
                <!-- Dashboard -->
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Dashboard</p>
                    </a>
                </li>

                <!-- Schedules -->
                <li class="nav-item">
                    <a href="<?php echo e(route('schedules.index')); ?>" class="nav-link <?php echo e(request()->routeIs('schedules.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-calendar-alt"></i>
                        <p>Schedules</p>
                    </a>
                </li>

                <!-- New Schedule -->
                <li class="nav-item">
                    <a href="<?php echo e(route('schedules.create')); ?>" class="nav-link <?php echo e(request()->routeIs('schedules.create') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-plus-circle"></i>
                        <p>New Schedule</p>
                    </a>
                </li>

                <!-- Connected Accounts -->
                <li class="nav-item">
                    <a href="<?php echo e(route('accounts.index')); ?>" class="nav-link <?php echo e(request()->routeIs('accounts.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-plug"></i>
                        <p>Connected Accounts</p>
                    </a>
                </li>

                <!-- Support -->
                <li class="nav-item">
                    <a href="<?php echo e(route('support.index')); ?>" class="nav-link <?php echo e(request()->routeIs('support.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-life-ring"></i>
                        <p>Support</p>
                    </a>
                </li>

                <li class="nav-header">SETTINGS</li>

                <!-- Profile -->
                <li class="nav-item">
                    <a href="<?php echo e(route('profile.index')); ?>" class="nav-link <?php echo e(request()->routeIs('profile.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-user"></i>
                        <p>Profile</p>
                    </a>
                </li>

                <!-- Subscription -->
                <li class="nav-item">
                    <a href="<?php echo e(route('subscription.index')); ?>" class="nav-link <?php echo e(request()->routeIs('subscription.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-credit-card"></i>
                        <p>Subscription</p>
                    </a>
                </li>

                <?php if(Auth::check() && Auth::user()->role === 'admin'): ?>
                <li class="nav-header">ADMIN</li>

                <!-- Support Tickets -->
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.support.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.support.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-headset"></i>
                        <p>Support Tickets</p>
                    </a>
                </li>

                <!-- Users -->
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.users.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-users"></i>
                        <p>Users</p>
                    </a>
                </li>

                <!-- Plans -->
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.plans.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.plans.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-crown"></i>
                        <p>Plans</p>
                    </a>
                </li>

                <!-- Payments -->
                <li class="nav-item has-treeview <?php echo e(request()->routeIs('admin.payments.*') || request()->routeIs('admin.subscriptions.*') ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link <?php echo e(request()->routeIs('admin.payments.*') || request()->routeIs('admin.subscriptions.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-credit-card"></i>
                        <p>
                            Payments
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.payments.index')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>All Payments</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.subscriptions.index')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Subscriptions</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.payments.gateways')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Gateway Settings</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Active Batches -->
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.batches.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.batches.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tasks"></i>
                        <p>Active Batches</p>
                    </a>
                </li>

                <!-- CMS -->
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.settings.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-file-alt"></i>
                        <p>CMS / Pages</p>
                    </a>
                </li>

                <!-- Ads -->
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.ads.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.ads.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-ad"></i>
                        <p>Ads</p>
                    </a>
                </li>

                <!-- System -->
                <li class="nav-item has-treeview <?php echo e(request()->routeIs('admin.system.*') ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link <?php echo e(request()->routeIs('admin.system.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-server"></i>
                        <p>
                            System
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.system.failed-jobs')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Failed Jobs</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.setup-guide')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.setup-guide') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Setup Guide</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.api-keys.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.api-keys.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>API Keys</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.system.logs')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Upload Logs</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>

            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH C:\Users\ogasm\Updit\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>