

<?php $__env->startSection('title', 'Support Tickets'); ?>
<?php $__env->startSection('page-title', 'Support Management'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Stats -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3><?php echo e($stats['open']); ?></h3>
                    <p>Open Tickets</p>
                </div>
                <div class="icon"><i class="fas fa-envelope-open"></i></div>
                <a href="<?php echo e(route('admin.support.index', ['status' => 'open'])); ?>" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo e($stats['in_progress']); ?></h3>
                    <p>In Progress</p>
                </div>
                <div class="icon"><i class="fas fa-spinner"></i></div>
                <a href="<?php echo e(route('admin.support.index', ['status' => 'in_progress'])); ?>" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo e($stats['waiting']); ?></h3>
                    <p>Awaiting Reply</p>
                </div>
                <div class="icon"><i class="fas fa-clock"></i></div>
                <a href="<?php echo e(route('admin.support.index', ['status' => 'waiting'])); ?>" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3><?php echo e($stats['urgent']); ?></h3>
                    <p>Urgent</p>
                </div>
                <div class="icon"><i class="fas fa-exclamation-triangle"></i></div>
                <a href="<?php echo e(route('admin.support.index', ['priority' => 'urgent'])); ?>" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Tickets Table -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-ticket-alt mr-2"></i>All Tickets</h3>
            <div class="card-tools">
                <form action="" method="GET" class="form-inline">
                    <select name="status" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                        <option value="all">All Status</option>
                        <option value="open" <?php echo e(request('status') == 'open' ? 'selected' : ''); ?>>Open</option>
                        <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>>In Progress</option>
                        <option value="waiting" <?php echo e(request('status') == 'waiting' ? 'selected' : ''); ?>>Waiting</option>
                        <option value="resolved" <?php echo e(request('status') == 'resolved' ? 'selected' : ''); ?>>Resolved</option>
                        <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>>Closed</option>
                    </select>
                    <select name="priority" class="form-control form-control-sm" onchange="this.form.submit()">
                        <option value="">All Priority</option>
                        <option value="urgent" <?php echo e(request('priority') == 'urgent' ? 'selected' : ''); ?>>Urgent</option>
                        <option value="high" <?php echo e(request('priority') == 'high' ? 'selected' : ''); ?>>High</option>
                        <option value="medium" <?php echo e(request('priority') == 'medium' ? 'selected' : ''); ?>>Medium</option>
                        <option value="low" <?php echo e(request('priority') == 'low' ? 'selected' : ''); ?>>Low</option>
                    </select>
                </form>
            </div>
        </div>
        <div class="card-body p-0">
            <?php if($tickets->count() > 0): ?>
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Ticket #</th>
                            <th>User</th>
                            <th>Subject</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>Status</th>
                            <th>Last Update</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($ticket->priority == 'urgent' ? 'table-danger' : ''); ?>">
                                <td><code><?php echo e($ticket->ticket_number); ?></code></td>
                                <td>
                                    <strong><?php echo e($ticket->user->name); ?></strong>
                                    <br><small class="text-muted"><?php echo e($ticket->user->email); ?></small>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.support.show', $ticket)); ?>">
                                        <?php echo e(Str::limit($ticket->subject, 35)); ?>

                                    </a>
                                </td>
                                <td>
                                    <i class="<?php echo e($ticket->category_icon); ?> mr-1"></i>
                                    <?php echo e(ucfirst($ticket->category)); ?>

                                </td>
                                <td>
                                    <span class="badge <?php echo e($ticket->priority_badge); ?>">
                                        <?php echo e(ucfirst($ticket->priority)); ?>

                                    </span>
                                </td>
                                <td>
                                    <span class="badge <?php echo e($ticket->status_badge); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $ticket->status))); ?>

                                    </span>
                                </td>
                                <td><?php echo e($ticket->last_reply_at?->diffForHumans() ?? '-'); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.support.show', $ticket)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <?php if(!$ticket->assigned_to): ?>
                                        <form action="<?php echo e(route('admin.support.assign', $ticket)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-success" title="Assign to me">
                                                <i class="fas fa-user-check"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No tickets found.</p>
                </div>
            <?php endif; ?>
        </div>
        <?php if($tickets->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($tickets->appends(request()->query())->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/admin/support/index.blade.php ENDPATH**/ ?>