

<?php $__env->startSection('title', 'Failed Jobs'); ?>
<?php $__env->startSection('page-title', 'Failed Jobs'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Failed Jobs</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-exclamation-triangle text-danger mr-2"></i>Failed Jobs Queue</h3>
        </div>
        <div class="card-body p-0">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Queue</th>
                        <th>Exception</th>
                        <th>Failed At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($job->id); ?></td>
                            <td><span class="badge badge-info"><?php echo e($job->queue); ?></span></td>
                            <td>
                                <small class="text-danger"><?php echo e(Str::limit($job->exception, 100)); ?></small>
                            </td>
                            <td><?php echo e(\Carbon\Carbon::parse($job->failed_at)->diffForHumans()); ?></td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <form action="<?php echo e(route('admin.system.retry-job', $job->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-warning" title="Retry">
                                            <i class="fas fa-redo"></i>
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.system.delete-job', $job->id)); ?>" method="POST" class="d-inline"
                                          onsubmit="return confirm('Delete this failed job?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center p-5">
                                <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                                <p class="text-muted mb-0">No failed jobs! Everything is running smoothly.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($jobs->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($jobs->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views\admin\system\failed-jobs.blade.php ENDPATH**/ ?>