

<?php $__env->startSection('title', 'Welcome'); ?>
<?php $__env->startSection('step1-class', 'active'); ?>

<?php $__env->startSection('content'); ?>
    <h2><i class="fas fa-rocket" style="color: #8b5cf6; margin-right: 10px;"></i>Welcome to Updit</h2>
    <p style="color: rgba(255,255,255,0.7); margin-bottom: 25px;">
        Before we begin, please make sure your server meets the following requirements.
    </p>
    
    <table class="requirements-table">
        <?php $__currentLoopData = $requirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($req['name']); ?></td>
                <td><?php echo e($req['current']); ?></td>
                <td>
                    <?php if($req['passed']): ?>
                        <i class="fas fa-check-circle badge-success"></i>
                    <?php else: ?>
                        <i class="fas fa-times-circle badge-danger"></i>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    
    <?php if($allPassed): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> All requirements passed! You can proceed with the installation.
        </div>
        <a href="<?php echo e(route('install.database')); ?>" class="btn btn-primary btn-block">
            Continue <i class="fas fa-arrow-right" style="margin-left: 10px;"></i>
        </a>
    <?php else: ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-triangle"></i> Some requirements are not met. Please fix them before continuing.
        </div>
        <button class="btn btn-primary btn-block" disabled>Continue</button>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('install.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/install/welcome.blade.php ENDPATH**/ ?>