

<?php $__env->startSection('title', 'Admin Setup'); ?>
<?php $__env->startSection('step1-class', 'completed'); ?>
<?php $__env->startSection('step2-class', 'completed'); ?>
<?php $__env->startSection('step3-class', 'active'); ?>

<?php $__env->startSection('content'); ?>
    <h2><i class="fas fa-user-shield" style="color: #8b5cf6; margin-right: 10px;"></i>Admin Account</h2>
    <p style="color: rgba(255,255,255,0.7); margin-bottom: 25px;">
        Create your administrator account and configure your site.
    </p>
    
    <form action="<?php echo e(route('install.admin.save')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        <div class="form-group">
            <label for="site_name">Site Name</label>
            <input type="text" name="site_name" id="site_name" class="form-control" 
                   value="<?php echo e(old('site_name', 'Updit')); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="site_url">Site URL</label>
            <input type="url" name="site_url" id="site_url" class="form-control" 
                   value="<?php echo e(old('site_url', url('/'))); ?>" placeholder="https://yourdomain.com" required>
        </div>
        
        <hr style="border-color: rgba(255,255,255,0.1); margin: 20px 0;">
        
        <div class="form-group">
            <label for="admin_name">Admin Name</label>
            <input type="text" name="admin_name" id="admin_name" class="form-control" 
                   value="<?php echo e(old('admin_name')); ?>" placeholder="John Doe" required>
        </div>
        
        <div class="form-group">
            <label for="admin_email">Admin Email</label>
            <input type="email" name="admin_email" id="admin_email" class="form-control" 
                   value="<?php echo e(old('admin_email')); ?>" placeholder="admin@example.com" required>
        </div>
        
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label for="admin_password">Password</label>
                    <input type="password" name="admin_password" id="admin_password" class="form-control" 
                           placeholder="Min 6 characters" required>
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="admin_password_confirmation">Confirm Password</label>
                    <input type="password" name="admin_password_confirmation" id="admin_password_confirmation" 
                           class="form-control" placeholder="Confirm password" required>
                </div>
            </div>
        </div>
        
        <button type="submit" class="btn btn-primary btn-block">
            <i class="fas fa-magic" style="margin-right: 10px;"></i> Install Updit
        </button>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('install.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views\install\admin.blade.php ENDPATH**/ ?>