

<?php $__env->startSection('title', 'Register'); ?>

<?php $__env->startSection('content'); ?>
    <div class="auth-header">
        <h1>Create an account</h1>
        <p>Start automating your YouTube publishing today</p>
    </div>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e($error); ?><br>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('register')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label for="name">Full Name</label>
            <div class="input-wrapper">
                <i class="fas fa-user"></i>
                <input type="text" id="name" name="name" placeholder="John Doe" value="<?php echo e(old('name')); ?>" required autofocus>
            </div>
        </div>

        <div class="form-group">
            <label for="email">Email Address</label>
            <div class="input-wrapper">
                <i class="fas fa-envelope"></i>
                <input type="email" id="email" name="email" placeholder="you@example.com" value="<?php echo e(old('email')); ?>" required>
            </div>
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <div class="input-wrapper">
                <i class="fas fa-lock"></i>
                <input type="password" id="password" name="password" placeholder="••••••••" minlength="6" required>
            </div>
        </div>

        <div class="form-group">
            <label for="password_confirmation">Confirm Password</label>
            <div class="input-wrapper">
                <i class="fas fa-lock"></i>
                <input type="password" id="password_confirmation" name="password_confirmation" placeholder="••••••••" required>
            </div>
        </div>

        <div class="form-options">
            <div class="checkbox-wrapper">
                <input type="checkbox" id="terms" name="terms" required>
                <label for="terms">I agree to the Terms & Privacy Policy</label>
            </div>
        </div>

        <button type="submit" class="btn btn-primary">
            <i class="fas fa-rocket"></i> Create Account
        </button>
    </form>

    <div class="auth-footer">
        <p>Already have an account? <a href="<?php echo e(route('login')); ?>">Sign in</a></p>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/auth/register.blade.php ENDPATH**/ ?>