

<?php $__env->startSection('title', 'Setup Guide'); ?>
<?php $__env->startSection('page-title', 'Platform Setup Guide'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.settings.index')); ?>">Settings</a></li>
    <li class="breadcrumb-item active">Setup Guide</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12">
            <!-- Status Overview -->
            <div class="card">
                <div class="card-header bg-primary">
                    <h3 class="card-title"><i class="fas fa-server mr-2"></i>Platform Status</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box <?php echo e(!empty(config('services.google.client_id')) ? 'bg-success' : 'bg-secondary'); ?>">
                                <span class="info-box-icon"><i class="fab fa-youtube"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">YouTube</span>
                                    <span class="info-box-number">
                                        <?php if(!empty(config('services.google.client_id'))): ?>
                                            <i class="fas fa-check"></i> Configured
                                        <?php else: ?>
                                            <i class="fas fa-times"></i> Not Configured
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box <?php echo e(!empty(config('services.facebook.client_id')) ? 'bg-success' : 'bg-secondary'); ?>">
                                <span class="info-box-icon"><i class="fab fa-facebook"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Facebook</span>
                                    <span class="info-box-number">
                                        <?php if(!empty(config('services.facebook.client_id'))): ?>
                                            <i class="fas fa-check"></i> Configured
                                        <?php else: ?>
                                            <i class="fas fa-times"></i> Not Configured
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box <?php echo e(!empty(config('services.tiktok.client_key')) ? 'bg-success' : 'bg-secondary'); ?>">
                                <span class="info-box-icon"><i class="fab fa-tiktok"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">TikTok</span>
                                    <span class="info-box-number">
                                        <?php if(!empty(config('services.tiktok.client_key'))): ?>
                                            <i class="fas fa-check"></i> Configured
                                        <?php else: ?>
                                            <i class="fas fa-times"></i> Not Configured
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- YouTube Setup -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-danger">
                <div class="card-header">
                    <h3 class="card-title"><i class="fab fa-youtube mr-2"></i>YouTube Setup (Google Cloud)</h3>
                    <div class="card-tools">
                        <?php if(!empty(config('services.google.client_id'))): ?>
                            <span class="badge badge-success">Configured</span>
                        <?php else: ?>
                            <span class="badge badge-warning">Setup Required</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-list-ol mr-2"></i>Setup Steps</h5>
                            <ol>
                                <li>Go to <a href="https://console.cloud.google.com" target="_blank">Google Cloud Console</a></li>
                                <li>Create a new project (e.g., "Updit")</li>
                                <li>Navigate to <strong>APIs & Services → Library</strong></li>
                                <li>Search and enable <strong>YouTube Data API v3</strong></li>
                                <li>Go to <strong>Credentials → Create Credentials → OAuth Client ID</strong></li>
                                <li>Application type: <strong>Web application</strong></li>
                                <li>Add Authorized redirect URI (see right panel)</li>
                                <li>Copy Client ID and Client Secret</li>
                            </ol>
                        </div>
                        <div class="col-md-6">
                            <h5><i class="fas fa-code mr-2"></i>Add to .env file</h5>
                            <pre class="bg-dark text-light p-3 rounded"><code>GOOGLE_CLIENT_ID=your-client-id
GOOGLE_CLIENT_SECRET=your-client-secret
GOOGLE_REDIRECT_URI=<?php echo e(url('/accounts/youtube/callback')); ?></code></pre>
                            
                            <div class="alert alert-info mt-3">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Redirect URI:</strong><br>
                                <code><?php echo e(url('/accounts/youtube/callback')); ?></code>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Facebook Setup -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fab fa-facebook mr-2"></i>Facebook Setup (Meta Developer)</h3>
                    <div class="card-tools">
                        <?php if(!empty(config('services.facebook.client_id'))): ?>
                            <span class="badge badge-success">Configured</span>
                        <?php else: ?>
                            <span class="badge badge-warning">Setup Required</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-list-ol mr-2"></i>Setup Steps</h5>
                            <ol>
                                <li>Go to <a href="https://developers.facebook.com" target="_blank">Meta Developer Portal</a></li>
                                <li>Create a new app (Type: <strong>Business</strong>)</li>
                                <li>Add <strong>Facebook Login</strong> product</li>
                                <li>Go to Facebook Login → Settings</li>
                                <li>Add Valid OAuth Redirect URI (see right panel)</li>
                                <li>Go to App Settings → Basic to get App ID and Secret</li>
                                <li>Request permissions: <code>pages_manage_posts</code>, <code>publish_video</code></li>
                                <li><strong>Important:</strong> Submit for App Review for public use</li>
                            </ol>
                        </div>
                        <div class="col-md-6">
                            <h5><i class="fas fa-code mr-2"></i>Add to .env file</h5>
                            <pre class="bg-dark text-light p-3 rounded"><code>FACEBOOK_CLIENT_ID=your-app-id
FACEBOOK_CLIENT_SECRET=your-app-secret
FACEBOOK_REDIRECT_URI=<?php echo e(url('/accounts/facebook/callback')); ?></code></pre>
                            
                            <div class="alert alert-info mt-3">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Redirect URI:</strong><br>
                                <code><?php echo e(url('/accounts/facebook/callback')); ?></code>
                            </div>
                            
                            <div class="alert alert-warning mt-3">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                Facebook requires <strong>App Review</strong> before your app can be used by users other than developers/testers.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- TikTok Setup -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-dark">
                <div class="card-header">
                    <h3 class="card-title"><i class="fab fa-tiktok mr-2"></i>TikTok Setup</h3>
                    <div class="card-tools">
                        <?php if(!empty(config('services.tiktok.client_key'))): ?>
                            <span class="badge badge-success">Configured</span>
                        <?php else: ?>
                            <span class="badge badge-warning">Setup Required</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-list-ol mr-2"></i>Setup Steps</h5>
                            <ol>
                                <li>Go to <a href="https://developers.tiktok.com" target="_blank">TikTok Developer Portal</a></li>
                                <li>Create a developer account</li>
                                <li>Create a new app</li>
                                <li>Request <strong>Content Posting API</strong> access</li>
                                <li>Add Redirect URI (see right panel)</li>
                                <li>Copy Client Key and Client Secret</li>
                                <li><strong>Wait for approval</strong> (TikTok manually reviews all apps)</li>
                            </ol>
                        </div>
                        <div class="col-md-6">
                            <h5><i class="fas fa-code mr-2"></i>Add to .env file</h5>
                            <pre class="bg-dark text-light p-3 rounded"><code>TIKTOK_CLIENT_KEY=your-client-key
TIKTOK_CLIENT_SECRET=your-client-secret
TIKTOK_REDIRECT_URI=<?php echo e(url('/accounts/tiktok/callback')); ?></code></pre>
                            
                            <div class="alert alert-info mt-3">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Redirect URI:</strong><br>
                                <code><?php echo e(url('/accounts/tiktok/callback')); ?></code>
                            </div>
                            
                            <div class="alert alert-danger mt-3">
                                <i class="fas fa-clock mr-2"></i>
                                TikTok Content Posting API requires <strong>manual approval</strong> which can take several days to weeks.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Server Requirements -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-success">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-server mr-2"></i>Server Requirements</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-clock mr-2"></i>Cron Job (Required)</h5>
                            <p>Add this to your server's crontab for scheduled uploads:</p>
                            <pre class="bg-dark text-light p-3 rounded"><code>* * * * * cd <?php echo e(base_path()); ?> && php artisan schedule:run >> /dev/null 2>&1</code></pre>
                        </div>
                        <div class="col-md-6">
                            <h5><i class="fas fa-cogs mr-2"></i>Queue Worker (Required)</h5>
                            <p>Run the queue worker to process video uploads:</p>
                            <pre class="bg-dark text-light p-3 rounded"><code>php artisan queue:work redis --daemon</code></pre>
                            <p class="text-muted">For production, use Supervisor to keep this running.</p>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <h5><i class="fas fa-redo mr-2"></i>After Adding Credentials</h5>
                            <p>After updating your <code>.env</code> file, clear the config cache:</p>
                            <pre class="bg-dark text-light p-3 rounded"><code>php artisan config:clear
php artisan cache:clear</code></pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Test -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header bg-info">
                    <h3 class="card-title"><i class="fas fa-vial mr-2"></i>Testing Without API Credentials</h3>
                </div>
                <div class="card-body">
                    <p>
                        <i class="fas fa-lightbulb text-warning mr-2"></i>
                        <strong>Simulation Mode:</strong> If no API credentials are configured, the system will use 
                        <strong>simulation mode</strong> for testing. Videos will be marked as uploaded with simulated 
                        video IDs (90% success rate). This is useful for testing the workflow without real API access.
                    </p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/admin/setup-guide.blade.php ENDPATH**/ ?>