

<?php $__env->startSection('title', 'Connected Accounts'); ?>
<?php $__env->startSection('page-title', 'Connected Accounts'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Connected Accounts</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Your Connected Accounts</h3>
                </div>
                <div class="card-body p-0">
                    <?php $__empty_1 = true; $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="p-4 border-bottom d-flex align-items-center">
                            <div class="mr-4">
                                <i class="<?php echo e($account->platform_icon); ?> fa-3x"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h5 class="mb-1"><?php echo e($account->platform_user_name); ?></h5>
                                <p class="text-muted mb-0">
                                    <?php
                                        $colors = ['youtube' => 'danger', 'facebook' => 'primary', 'tiktok' => 'dark'];
                                    ?>
                                    <span class="badge badge-<?php echo e($colors[$account->platform] ?? 'secondary'); ?>">
                                        <?php echo e(ucfirst($account->platform)); ?>

                                    </span>
                                    <?php if($account->needs_reauth): ?>
                                        <span class="badge badge-warning ml-2">
                                            <i class="fas fa-exclamation-triangle"></i> Needs Re-authentication
                                        </span>
                                    <?php else: ?>
                                        <span class="badge badge-success ml-2">Connected</span>
                                    <?php endif; ?>
                                </p>
                                <small class="text-muted">
                                    Connected <?php echo e($account->created_at->diffForHumans()); ?>

                                    <?php if($account->expires_at): ?>
                                        • Token expires <?php echo e($account->expires_at->diffForHumans()); ?>

                                    <?php endif; ?>
                                </small>
                            </div>
                            <div>
                                <?php if($account->needs_reauth): ?>
                                    <a href="<?php echo e(route("accounts.{$account->platform}.redirect")); ?>" class="btn btn-warning mr-2">
                                        <i class="fas fa-sync"></i> Reconnect
                                    </a>
                                <?php endif; ?>
                                <form action="<?php echo e(route('accounts.disconnect', $account)); ?>" method="POST" class="d-inline"
                                      onsubmit="return confirm('Disconnect this account? Active schedules using it will be paused.')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-outline-danger">
                                        <i class="fas fa-unlink"></i> Disconnect
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="p-5 text-center">
                            <i class="fas fa-plug fa-4x text-muted mb-3"></i>
                            <h5>No Accounts Connected</h5>
                            <p class="text-muted">Connect your social media accounts to start scheduling videos</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-plus mr-2"></i>Connect New Account</h3>
                </div>
                <div class="card-body">
                    <p>Connect your social media accounts to enable video publishing.</p>
                    
                    <?php $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($platform['connected']): ?>
                            <button class="btn btn-success btn-block mb-3" disabled>
                                <i class="<?php echo e($platform['icon']); ?> mr-2"></i> <?php echo e($platform['name']); ?> Connected
                                <i class="fas fa-check ml-2"></i>
                            </button>
                        <?php elseif($platform['configured']): ?>
                            <a href="<?php echo e(route("accounts.{$key}.redirect")); ?>" class="btn btn-<?php echo e($platform['color']); ?> btn-block mb-3">
                                <i class="<?php echo e($platform['icon']); ?> mr-2"></i> Connect <?php echo e($platform['name']); ?>

                            </a>
                        <?php else: ?>
                            <button class="btn btn-secondary btn-block mb-3" disabled title="Not configured by admin">
                                <i class="<?php echo e($platform['icon']); ?> mr-2"></i> <?php echo e($platform['name']); ?>

                                <small>(Not Configured)</small>
                            </button>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="card card-outline card-info">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-info-circle mr-2"></i>About Permissions</h3>
                </div>
                <div class="card-body">
                    <p class="text-muted mb-0">
                        We only request the minimum permissions needed to upload videos on your behalf:
                    </p>
                    <ul class="mt-2 mb-0 text-muted">
                        <li><strong>YouTube:</strong> Upload & read channel info</li>
                        <li><strong>Facebook:</strong> Post videos to Pages</li>
                        <li><strong>TikTok:</strong> Upload & publish videos</li>
                    </ul>
                    <hr>
                    <small class="text-muted">
                        <i class="fas fa-lock"></i> Your credentials are encrypted and securely stored.
                        You can disconnect at any time.
                    </small>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/accounts/index.blade.php ENDPATH**/ ?>