

<?php $__env->startSection('title', 'Manage Users'); ?>
<?php $__env->startSection('page-title', 'User Management'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Users</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Users</h3>
        </div>
        <div class="card-body">
            <table class="table table-hover table-striped" id="usersTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Plan</th>
                        <th>Schedules</th>
                        <th>Videos</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($user->id); ?></td>
                            <td>
                                <?php echo e($user->name); ?>

                                <?php if($user->role === 'admin'): ?>
                                    <span class="badge badge-purple">Admin</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($user->email); ?></td>
                            <td>
                                <span class="badge badge-info"><?php echo e($user->plan->name ?? 'None'); ?></span>
                            </td>
                            <td><?php echo e($user->schedules_count); ?></td>
                            <td><?php echo e($user->videos_count); ?></td>
                            <td>
                                <?php if($user->is_active): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Banned</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="btn btn-info" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    
                                    <form action="<?php echo e(route('admin.users.reset-quota', $user)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-warning" title="Reset Quota">
                                            <i class="fas fa-redo"></i>
                                        </button>
                                    </form>

                                    <?php if($user->role !== 'admin'): ?>
                                        <?php if($user->is_active): ?>
                                            <form action="<?php echo e(route('admin.users.ban', $user)); ?>" method="POST" class="d-inline"
                                                  onsubmit="return confirm('Ban this user?')">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-danger" title="Ban">
                                                    <i class="fas fa-ban"></i>
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('admin.users.unban', $user)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-success" title="Unban">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php if($users->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($users->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#usersTable').DataTable({
            "paging": false,
            "info": false,
            "order": [[0, "desc"]]
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views\admin\users\index.blade.php ENDPATH**/ ?>