

<?php $__env->startSection('title', 'Subscription'); ?>
<?php $__env->startSection('page-title', 'Subscription & Billing'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Subscription</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <!-- Current Plan -->
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-crown mr-2"></i>Current Plan</h3>
                </div>
                <div class="card-body text-center">
                    <h2 class="mb-0"><?php echo e($user->plan->name ?? 'Free'); ?></h2>
                    <?php if($user->plan && $user->plan->price > 0): ?>
                        <p class="text-success">$<?php echo e(number_format($user->plan->price, 2)); ?>/month</p>
                    <?php else: ?>
                        <p class="text-muted">Free Forever</p>
                    <?php endif; ?>
                    
                    <?php if($currentSubscription && $currentSubscription->ends_at): ?>
                        <div class="alert alert-info mt-3">
                            <i class="fas fa-calendar mr-2"></i>
                            Renews: <?php echo e($currentSubscription->ends_at->format('M d, Y')); ?>

                            <br>
                            <small><?php echo e($currentSubscription->daysRemaining()); ?> days remaining</small>
                        </div>
                    <?php endif; ?>

                    <hr>
                    
                    <ul class="list-unstyled text-left">
                        <li><i class="fas fa-check text-success mr-2"></i><?php echo e($user->plan->max_videos_per_batch ?? 5); ?> videos per batch</li>
                        <li><i class="fas fa-check text-success mr-2"></i><?php echo e($user->plan->min_interval_minutes ?? 30); ?> min interval</li>
                        <li><i class="fas fa-check text-success mr-2"></i><?php echo e($user->plan->daily_upload_cap ?? 10); ?> daily uploads</li>
                    </ul>
                    
                    <?php if($currentSubscription): ?>
                        <form action="<?php echo e(route('subscription.cancel')); ?>" method="POST" class="mt-3">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-outline-danger btn-sm"
                                    onclick="return confirm('Cancel subscription?')">
                                Cancel Subscription
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Payment History -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-history mr-2"></i>Payment History</h3>
                </div>
                <div class="card-body p-0">
                    <?php if($paymentHistory->count() > 0): ?>
                        <table class="table table-sm mb-0">
                            <?php $__currentLoopData = $paymentHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <small><?php echo e($payment->created_at->format('M d, Y')); ?></small>
                                        <br><?php echo e($payment->plan->name ?? 'N/A'); ?>

                                    </td>
                                    <td class="text-right">
                                        $<?php echo e(number_format($payment->amount, 2)); ?>

                                        <br>
                                        <span class="badge badge-<?php echo e($payment->status_badge); ?>">
                                            <?php echo e(ucfirst($payment->status)); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    <?php else: ?>
                        <p class="text-muted text-center py-3 mb-0">No payments yet</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Upgrade Options -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-gradient-primary">
                    <h3 class="card-title"><i class="fas fa-arrow-up mr-2"></i>Upgrade Your Plan</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($plan->id !== $user->plan_id): ?>
                                <div class="col-md-6 mb-3">
                                    <div class="card h-100 <?php echo e($plan->price > 30 ? 'border-warning' : 'border-primary'); ?>">
                                        <div class="card-header text-center">
                                            <h4 class="mb-0"><?php echo e($plan->name); ?></h4>
                                            <h2 class="mt-2 mb-0">
                                                <?php if($plan->price > 0): ?>
                                                    $<?php echo e(number_format($plan->price, 0)); ?>

                                                <?php else: ?>
                                                    Free
                                                <?php endif; ?>
                                            </h2>
                                            <?php if($plan->price > 0): ?>
                                                <small class="text-muted">/month</small>
                                            <?php endif; ?>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled">
                                                <li><i class="fas fa-video mr-2 text-primary"></i><?php echo e($plan->max_videos_per_batch); ?> videos/batch</li>
                                                <li><i class="fas fa-clock mr-2 text-primary"></i><?php echo e($plan->min_interval_minutes); ?> min interval</li>
                                                <li><i class="fas fa-upload mr-2 text-primary"></i><?php echo e($plan->daily_upload_cap); ?> daily uploads</li>
                                            </ul>
                                        </div>
                                        <div class="card-footer">
                                            <?php if($plan->price > 0): ?>
                                                <button type="button" class="btn btn-primary btn-block" 
                                                        data-toggle="modal" data-target="#paymentModal-<?php echo e($plan->id); ?>">
                                                    <i class="fas fa-credit-card mr-2"></i>Upgrade Now
                                                </button>
                                            <?php else: ?>
                                                <form action="<?php echo e(route('subscription.upgrade')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="plan_id" value="<?php echo e($plan->id); ?>">
                                                    <input type="hidden" name="payment_method" value="manual">
                                                    <button type="submit" class="btn btn-outline-secondary btn-block">
                                                        Downgrade to Free
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- Payment Modal -->
                                <?php if($plan->price > 0): ?>
                                    <div class="modal fade" id="paymentModal-<?php echo e($plan->id); ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header bg-gradient-primary">
                                                    <h5 class="modal-title">Upgrade to <?php echo e($plan->name); ?></h5>
                                                    <button type="button" class="close" data-dismiss="modal">
                                                        <span>&times;</span>
                                                    </button>
                                                </div>
                                                <form action="<?php echo e(route('subscription.upgrade')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="plan_id" value="<?php echo e($plan->id); ?>">
                                                    <div class="modal-body">
                                                        <h4 class="text-center mb-4">
                                                            Total: $<?php echo e(number_format($plan->price, 2)); ?>/month
                                                        </h4>
                                                        
                                                        <div class="form-group">
                                                            <label>Select Payment Method</label>
                                                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="custom-control custom-radio">
                                                                    <input type="radio" name="payment_method" 
                                                                           value="<?php echo e($gateway->name); ?>" 
                                                                           id="gateway-<?php echo e($plan->id); ?>-<?php echo e($gateway->name); ?>"
                                                                           class="custom-control-input" required>
                                                                    <label class="custom-control-label" 
                                                                           for="gateway-<?php echo e($plan->id); ?>-<?php echo e($gateway->name); ?>">
                                                                        <i class="<?php echo e($gateway->icon); ?> mr-2"></i>
                                                                        <?php echo e($gateway->display_name); ?>

                                                                    </label>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">
                                                            <i class="fas fa-lock mr-2"></i>Continue to Payment
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <?php if($gateways->isEmpty()): ?>
                        <div class="alert alert-warning text-center">
                            <i class="fas fa-exclamation-triangle mr-2"></i>
                            No payment methods are currently available. Please contact support.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/subscription/index.blade.php ENDPATH**/ ?>