

<?php $__env->startSection('title', 'Payment Gateways'); ?>
<?php $__env->startSection('page-title', 'Payment Gateway Settings'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Payment Gateways</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6">
                <div class="card card-<?php echo e($gateway->is_active ? 'success' : 'secondary'); ?> card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="<?php echo e($gateway->icon); ?> mr-2"></i>
                            <?php echo e($gateway->display_name); ?>

                        </h3>
                        <div class="card-tools">
                            <span class="badge badge-<?php echo e($gateway->is_active ? 'success' : 'danger'); ?>">
                                <?php echo e($gateway->is_active ? 'Active' : 'Disabled'); ?>

                            </span>
                        </div>
                    </div>
                    <form action="<?php echo e(route('admin.payments.gateways.update', $gateway)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="card-body">
                            <div class="form-group">
                                <label>Display Name</label>
                                <input type="text" name="display_name" class="form-control" 
                                       value="<?php echo e($gateway->display_name); ?>" required>
                            </div>
                            
                            <div class="custom-control custom-switch mb-3">
                                <input type="checkbox" name="is_active" value="1" 
                                       class="custom-control-input" id="active-<?php echo e($gateway->id); ?>"
                                       <?php echo e($gateway->is_active ? 'checked' : ''); ?>>
                                <label class="custom-control-label" for="active-<?php echo e($gateway->id); ?>">
                                    Enable this gateway
                                </label>
                            </div>

                            <?php if($gateway->name === 'paypal'): ?>
                                <div class="form-group">
                                    <label>Client ID</label>
                                    <input type="text" name="client_id" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('client_id')); ?>" placeholder="PayPal Client ID">
                                </div>
                                <div class="form-group">
                                    <label>Client Secret</label>
                                    <input type="password" name="client_secret" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('client_secret')); ?>" placeholder="PayPal Client Secret">
                                </div>
                                <div class="form-group">
                                    <label>Mode</label>
                                    <select name="mode" class="form-control">
                                        <option value="sandbox" <?php echo e($gateway->getConfig('mode') === 'sandbox' ? 'selected' : ''); ?>>Sandbox</option>
                                        <option value="live" <?php echo e($gateway->getConfig('mode') === 'live' ? 'selected' : ''); ?>>Live</option>
                                    </select>
                                </div>

                            <?php elseif($gateway->name === 'paystack'): ?>
                                <div class="form-group">
                                    <label>Public Key</label>
                                    <input type="text" name="public_key" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('public_key')); ?>" placeholder="pk_xxx">
                                </div>
                                <div class="form-group">
                                    <label>Secret Key</label>
                                    <input type="password" name="secret_key" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('secret_key')); ?>" placeholder="sk_xxx">
                                </div>

                            <?php elseif($gateway->name === 'flutterwave'): ?>
                                <div class="form-group">
                                    <label>Public Key</label>
                                    <input type="text" name="public_key" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('public_key')); ?>" placeholder="FLWPUBK-xxx">
                                </div>
                                <div class="form-group">
                                    <label>Secret Key</label>
                                    <input type="password" name="secret_key" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('secret_key')); ?>" placeholder="FLWSECK-xxx">
                                </div>
                                <div class="form-group">
                                    <label>Encryption Key</label>
                                    <input type="password" name="encryption_key" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('encryption_key')); ?>" placeholder="Encryption Key">
                                </div>

                            <?php elseif($gateway->name === 'skrill'): ?>
                                <div class="form-group">
                                    <label>Merchant ID</label>
                                    <input type="text" name="merchant_id" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('merchant_id')); ?>" placeholder="Merchant ID">
                                </div>
                                <div class="form-group">
                                    <label>Secret Word</label>
                                    <input type="password" name="secret_word" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('secret_word')); ?>" placeholder="Secret Word">
                                </div>

                            <?php elseif($gateway->name === 'opay'): ?>
                                <div class="form-group">
                                    <label>Merchant ID</label>
                                    <input type="text" name="merchant_id" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('merchant_id')); ?>" placeholder="Merchant ID">
                                </div>
                                <div class="form-group">
                                    <label>Public Key</label>
                                    <input type="text" name="public_key" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('public_key')); ?>" placeholder="Public Key">
                                </div>
                                <div class="form-group">
                                    <label>Secret Key</label>
                                    <input type="password" name="secret_key" class="form-control" 
                                           value="<?php echo e($gateway->getConfig('secret_key')); ?>" placeholder="Secret Key">
                                </div>

                            <?php elseif($gateway->name === 'manual'): ?>
                                <div class="form-group">
                                    <label>Payment Instructions</label>
                                    <textarea name="instructions" class="form-control" rows="4" 
                                              placeholder="Instructions for manual payment (bank details, etc.)"><?php echo e($gateway->instructions); ?></textarea>
                                    <small class="text-muted">This will be shown to users who select manual payment.</small>
                                </div>
                            <?php endif; ?>

                            <div class="form-group">
                                <label>Sort Order</label>
                                <input type="number" name="sort_order" class="form-control" 
                                       value="<?php echo e($gateway->sort_order); ?>" min="0">
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-2"></i>Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php if($gateways->isEmpty()): ?>
        <div class="alert alert-info">
            <i class="fas fa-info-circle mr-2"></i>
            No payment gateways configured. Run the seeder to add default gateways.
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/admin/payments/gateways.blade.php ENDPATH**/ ?>