

<?php $__env->startSection('title', 'User: ' . $user->name); ?>
<?php $__env->startSection('page-title', 'User Details'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.users.index')); ?>">Users</a></li>
    <li class="breadcrumb-item active"><?php echo e($user->name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <!-- User Info Card -->
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="text-center">
                        <div class="rounded-circle bg-gradient-primary d-inline-flex align-items-center justify-content-center" 
                             style="width: 80px; height: 80px; font-size: 2rem; color: white;">
                            <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                        </div>
                    </div>
                    <h3 class="profile-username text-center mt-3"><?php echo e($user->name); ?></h3>
                    <p class="text-muted text-center">
                        <?php echo e($user->email); ?>

                        <?php if($user->email_verified_at): ?>
                            <i class="fas fa-check-circle text-success" title="Verified"></i>
                        <?php else: ?>
                            <i class="fas fa-times-circle text-danger" title="Not Verified"></i>
                        <?php endif; ?>
                    </p>
                    
                    <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                            <b>Role</b>
                            <span class="float-right badge <?php echo e($user->role === 'admin' ? 'badge-purple' : 'badge-info'); ?>">
                                <?php echo e(ucfirst($user->role)); ?>

                            </span>
                        </li>
                        <li class="list-group-item">
                            <b>Plan</b>
                            <span class="float-right badge badge-success"><?php echo e($user->plan->name); ?></span>
                        </li>
                        <li class="list-group-item">
                            <b>Status</b>
                            <span class="float-right badge <?php echo e($user->is_active ? 'badge-success' : 'badge-danger'); ?>">
                                <?php echo e($user->is_active ? 'Active' : 'Suspended'); ?>

                            </span>
                        </li>
                        <li class="list-group-item">
                            <b>Joined</b>
                            <span class="float-right"><?php echo e($user->created_at->format('M d, Y')); ?></span>
                        </li>
                    </ul>

                    <div class="btn-group d-flex mb-2">
                        <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="btn btn-info">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <?php if($user->role !== 'admin'): ?>
                            <form action="<?php echo e(route('admin.users.impersonate', $user)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-user-secret"></i> Login As
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Stats Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-chart-bar mr-2"></i>Statistics</h3>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Total Videos</span>
                            <strong><?php echo e($stats['total_videos']); ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Uploaded</span>
                            <strong class="text-success"><?php echo e($stats['uploaded_videos']); ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Pending</span>
                            <strong class="text-warning"><?php echo e($stats['pending_videos']); ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Total Schedules</span>
                            <strong><?php echo e($stats['total_schedules']); ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Active Schedules</span>
                            <strong class="text-success"><?php echo e($stats['active_schedules']); ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Connected Accounts</span>
                            <strong><?php echo e($stats['connected_accounts']); ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Storage Used</span>
                            <strong><?php echo e($stats['storage_used']); ?></strong>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Actions Column -->
        <div class="col-md-8">
            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header bg-gradient-primary">
                    <h3 class="card-title"><i class="fas fa-bolt mr-2"></i>Quick Actions</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Password Actions -->
                        <div class="col-md-6">
                            <h5><i class="fas fa-key mr-2"></i>Password</h5>
                            <form action="<?php echo e(route('admin.users.generate-password', $user)); ?>" method="POST" class="mb-3">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-warning btn-block"
                                        onclick="return confirm('Generate a new random password?')">
                                    <i class="fas fa-random mr-2"></i>Generate Random Password
                                </button>
                            </form>
                            
                            <form action="<?php echo e(route('admin.users.reset-password', $user)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="input-group mb-2">
                                    <input type="password" name="new_password" class="form-control" 
                                           placeholder="New Password" required minlength="6">
                                </div>
                                <div class="input-group mb-2">
                                    <input type="password" name="new_password_confirmation" class="form-control" 
                                           placeholder="Confirm Password" required>
                                </div>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-save mr-2"></i>Set New Password
                                </button>
                            </form>
                        </div>

                        <!-- Email Actions -->
                        <div class="col-md-6">
                            <h5><i class="fas fa-envelope mr-2"></i>Email</h5>
                            <form action="<?php echo e(route('admin.users.update-email', $user)); ?>" method="POST" class="mb-3">
                                <?php echo csrf_field(); ?>
                                <div class="input-group mb-2">
                                    <input type="email" name="email" class="form-control" 
                                           value="<?php echo e($user->email); ?>" required>
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                    </div>
                                </div>
                            </form>
                            
                            <?php if($user->email_verified_at): ?>
                                <form action="<?php echo e(route('admin.users.unverify-email', $user)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-warning btn-block">
                                        <i class="fas fa-times mr-2"></i>Mark as Unverified
                                    </button>
                                </form>
                            <?php else: ?>
                                <form action="<?php echo e(route('admin.users.verify-email', $user)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-success btn-block">
                                        <i class="fas fa-check mr-2"></i>Verify Email
                                    </button>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <!-- Plan Change -->
                        <div class="col-md-6">
                            <h5><i class="fas fa-crown mr-2"></i>Subscription</h5>
                            <form action="<?php echo e(route('admin.users.change-plan', $user)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="input-group">
                                    <select name="plan_id" class="form-control">
                                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($plan->id); ?>" <?php echo e($user->plan_id == $plan->id ? 'selected' : ''); ?>>
                                                <?php echo e($plan->name); ?> ($<?php echo e($plan->price); ?>/mo)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-success">Change</button>
                                    </div>
                                </div>
                            </form>
                            
                            <form action="<?php echo e(route('admin.users.reset-quota', $user)); ?>" method="POST" class="mt-2">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-info btn-block">
                                    <i class="fas fa-redo mr-2"></i>Reset Daily Quota
                                </button>
                            </form>
                        </div>

                        <!-- Account Status -->
                        <div class="col-md-6">
                            <h5><i class="fas fa-user-shield mr-2"></i>Account Status</h5>
                            <?php if($user->role !== 'admin'): ?>
                                <?php if($user->is_active): ?>
                                    <form action="<?php echo e(route('admin.users.ban', $user)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-danger btn-block"
                                                onclick="return confirm('Suspend this user? Their schedules will be paused.')">
                                            <i class="fas fa-ban mr-2"></i>Suspend User
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <form action="<?php echo e(route('admin.users.unban', $user)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-success btn-block">
                                            <i class="fas fa-check mr-2"></i>Activate User
                                        </button>
                                    </form>
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="alert alert-info mb-0">
                                    <i class="fas fa-info-circle mr-2"></i>Admin accounts cannot be suspended.
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Connected Accounts -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fab fa-youtube mr-2"></i>Connected Accounts</h3>
                </div>
                <div class="card-body">
                    <?php if($user->socialAccounts->count() > 0): ?>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Platform</th>
                                    <th>Username</th>
                                    <th>Status</th>
                                    <th>Connected</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $user->socialAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><i class="<?php echo e($account->platform_icon); ?> mr-2"></i><?php echo e(ucfirst($account->platform)); ?></td>
                                        <td><?php echo e($account->platform_user_name ?? 'N/A'); ?></td>
                                        <td>
                                            <?php if($account->needs_reauth): ?>
                                                <span class="badge badge-warning">Needs Reauth</span>
                                            <?php else: ?>
                                                <span class="badge badge-success">Connected</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($account->created_at->format('M d, Y')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <form action="<?php echo e(route('admin.users.disconnect-accounts', $user)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-warning btn-sm"
                                    onclick="return confirm('Disconnect all social accounts?')">
                                <i class="fas fa-unlink mr-2"></i>Disconnect All
                            </button>
                        </form>
                    <?php else: ?>
                        <p class="text-muted mb-0">No accounts connected.</p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Recent Schedules -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-calendar mr-2"></i>Schedules</h3>
                </div>
                <div class="card-body p-0">
                    <?php if($user->schedules->count() > 0): ?>
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Videos</th>
                                    <th>Progress</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $user->schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($schedule->name ?? 'Schedule #' . $schedule->id); ?></td>
                                        <td><span class="badge badge-<?php echo e($schedule->status_badge); ?>"><?php echo e(ucfirst($schedule->status)); ?></span></td>
                                        <td><?php echo e($schedule->videos->count()); ?></td>
                                        <td>
                                            <div class="progress" style="height: 15px;">
                                                <div class="progress-bar bg-success" style="width: <?php echo e($schedule->progress); ?>%">
                                                    <?php echo e($schedule->progress); ?>%
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p class="text-muted text-center py-3 mb-0">No schedules created.</p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Danger Zone -->
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-exclamation-triangle mr-2"></i>Danger Zone</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <form action="<?php echo e(route('admin.users.clear-data', $user)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-outline-danger btn-block"
                                        onclick="return confirm('DELETE all schedules and videos for this user? This cannot be undone!')">
                                    <i class="fas fa-trash-alt mr-2"></i>Clear All Data
                                </button>
                            </form>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo e(route('admin.users.export', $user)); ?>" class="btn btn-outline-info btn-block" target="_blank">
                                <i class="fas fa-download mr-2"></i>Export User Data
                            </a>
                        </div>
                        <?php if($user->role !== 'admin'): ?>
                            <div class="col-md-4">
                                <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-block"
                                            onclick="return confirm('PERMANENTLY DELETE this user? This cannot be undone!')">
                                        <i class="fas fa-user-times mr-2"></i>Delete User
                                    </button>
                                </form>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/admin/users/show.blade.php ENDPATH**/ ?>