

<?php $__env->startSection('title', 'Create Schedule'); ?>
<?php $__env->startSection('page-title', 'Create New Schedule'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('schedules.index')); ?>">Schedules</a></li>
    <li class="breadcrumb-item active">Create</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if($accounts->isEmpty()): ?>
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i>
            You need to connect a YouTube account first.
            <a href="<?php echo e(route('accounts.index')); ?>" class="btn btn-sm btn-primary ml-2">Connect Account</a>
        </div>
    <?php else: ?>
        <form action="<?php echo e(route('schedules.store')); ?>" method="POST" enctype="multipart/form-data" id="scheduleForm">
            <?php echo csrf_field(); ?>
            
            <div class="row">
                <div class="col-md-8">
                    <!-- Video Upload Card -->
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fas fa-video mr-2"></i>Upload Videos</h3>
                        </div>
                        <div class="card-body">
                            <div id="dropzone" class="dropzone">
                                <div class="dz-message">
                                    <i class="fas fa-cloud-upload-alt fa-3x mb-3" style="color: var(--updit-primary);"></i>
                                    <h4>Drop videos here or click to upload</h4>
                                    <p class="text-muted">
                                        Maximum <?php echo e($plan->max_videos_per_batch); ?> videos per batch
                                        <br>Max 500MB per video
                                    </p>
                                </div>
                            </div>
                            
                            <div id="fileList" class="mt-3"></div>

                            <?php $__errorArgs = ['videos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger mt-2"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php $__errorArgs = ['videos.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger mt-2"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <!-- Metadata Card -->
                    <div class="card card-outline card-primary">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fas fa-tags mr-2"></i>Video Metadata</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="title_template">Title Template <span class="text-danger">*</span></label>
                                <input type="text" name="title_template" id="title_template" 
                                       class="form-control <?php $__errorArgs = ['title_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('title_template', 'Video {index}')); ?>"
                                       placeholder="My Video {index}" required>
                                <small class="form-text text-muted">
                                    Use <code>{index}</code> to insert video number (1, 2, 3...)
                                </small>
                                <?php $__errorArgs = ['title_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="description_template">Description Template</label>
                                <textarea name="description_template" id="description_template" rows="4"
                                          class="form-control <?php $__errorArgs = ['description_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                          placeholder="Video description..."><?php echo e(old('description_template')); ?></textarea>
                                <small class="form-text text-muted">
                                    Use <code>{index}</code> to insert video number
                                </small>
                                <?php $__errorArgs = ['description_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Settings Card -->
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fas fa-cog mr-2"></i>Schedule Settings</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="name">Schedule Name</label>
                                <input type="text" name="name" id="name" 
                                       class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('name')); ?>"
                                       placeholder="My Video Schedule">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="social_account_id">YouTube Account <span class="text-danger">*</span></label>
                                <select name="social_account_id" id="social_account_id" 
                                        class="form-control <?php $__errorArgs = ['social_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($account->id); ?>" <?php echo e(old('social_account_id') == $account->id ? 'selected' : ''); ?>>
                                            <?php echo e($account->platform_user_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['social_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="interval_minutes">Upload Interval <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" name="interval_minutes" id="interval_minutes" 
                                           class="form-control <?php $__errorArgs = ['interval_minutes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('interval_minutes', $plan->min_interval_minutes)); ?>"
                                           min="<?php echo e($plan->min_interval_minutes); ?>" required>
                                    <div class="input-group-append">
                                        <span class="input-group-text">minutes</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">
                                    Minimum: <?php echo e($plan->min_interval_minutes); ?> minutes (<?php echo e($plan->name); ?> plan)
                                </small>
                                <?php $__errorArgs = ['interval_minutes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="upload_mode">Upload Mode</label>
                                <select name="upload_mode" id="upload_mode" class="form-control">
                                    <option value="normal" <?php echo e(old('upload_mode') === 'normal' ? 'selected' : ''); ?>>
                                        Normal Videos
                                    </option>
                                    <option value="shorts" <?php echo e(old('upload_mode') === 'shorts' ? 'selected' : ''); ?>>
                                        YouTube Shorts
                                    </option>
                                </select>
                                <small class="form-text text-muted">
                                    Shorts mode automatically adds #Shorts hashtag
                                </small>
                            </div>

                            <div class="custom-control custom-switch mb-3">
                                <input type="checkbox" class="custom-control-input" id="auto_restart" 
                                       name="auto_restart" value="1" <?php echo e(old('auto_restart', true) ? 'checked' : ''); ?>>
                                <label class="custom-control-label" for="auto_restart">
                                    Smart Auto-Restart
                                </label>
                                <small class="form-text text-muted">
                                    Automatically resume after 24h if quota is exceeded
                                </small>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary btn-block" id="submitBtn" disabled>
                                <i class="fas fa-rocket mr-2"></i>Create Schedule
                            </button>
                        </div>
                    </div>

                    <!-- Plan Info -->
                    <div class="card card-outline card-info">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fas fa-crown mr-2"></i>Your Plan: <?php echo e($plan->name); ?></h3>
                        </div>
                        <div class="card-body">
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success mr-2"></i><?php echo e($plan->max_videos_per_batch); ?> videos per batch</li>
                                <li><i class="fas fa-check text-success mr-2"></i><?php echo e($plan->min_interval_minutes); ?> min minimum interval</li>
                                <li><i class="fas fa-check text-success mr-2"></i><?php echo e($plan->daily_upload_cap); ?> uploads per day</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .dropzone {
        min-height: 250px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }
    .dropzone .dz-preview {
        margin: 10px;
    }
    .dropzone .dz-preview .dz-image {
        border-radius: 8px;
    }
    .file-item {
        display: flex;
        align-items: center;
        padding: 10px;
        background: #f8f9fa;
        border-radius: 8px;
        margin-bottom: 8px;
    }
    .file-item .file-icon {
        width: 40px;
        height: 40px;
        background: var(--updit-gradient);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        margin-right: 12px;
    }
    .file-item .file-info {
        flex: 1;
    }
    .file-item .file-size {
        color: #6c757d;
        font-size: 0.85em;
    }
    .file-item .remove-file {
        color: #dc3545;
        cursor: pointer;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    Dropzone.autoDiscover = false;
    
    const maxFiles = <?php echo e($plan->max_videos_per_batch); ?>;
    let uploadedFiles = [];
    
    const dropzone = new Dropzone("#dropzone", {
        url: "<?php echo e(route('schedules.store')); ?>",
        autoProcessQueue: false,
        uploadMultiple: true,
        parallelUploads: maxFiles,
        maxFiles: maxFiles,
        maxFilesize: 500, // MB
        acceptedFiles: "video/*",
        addRemoveLinks: true,
        paramName: "videos",
        
        init: function() {
            const dz = this;
            const form = document.getElementById('scheduleForm');
            const submitBtn = document.getElementById('submitBtn');
            
            this.on("addedfile", function(file) {
                updateSubmitButton();
            });
            
            this.on("removedfile", function(file) {
                updateSubmitButton();
            });
            
            // Handle form submission
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                
                if (dz.files.length === 0) {
                    alert('Please add at least one video');
                    return;
                }
                
                // Add files to form
                const formData = new FormData(form);
                dz.files.forEach((file, index) => {
                    formData.append('videos[]', file);
                });
                
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Uploading...';
                
                fetch(form.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(response => {
                    if (response.redirected) {
                        window.location.href = response.url;
                    } else {
                        return response.text().then(text => {
                            throw new Error(text);
                        });
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Upload failed. Please try again.');
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = '<i class="fas fa-rocket mr-2"></i>Create Schedule';
                });
            });
            
            function updateSubmitButton() {
                submitBtn.disabled = dz.files.length === 0;
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/schedules/create.blade.php ENDPATH**/ ?>