

<?php $__env->startSection('title', 'CMS Settings'); ?>
<?php $__env->startSection('page-title', 'CMS & Page Editor'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Settings</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">
            <div class="col-md-6">
                <!-- About Us -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">About Us</h3>
                    </div>
                    <div class="card-body">
                        <textarea name="about_us" rows="6" class="form-control"><?php echo e($settings['about_us']); ?></textarea>
                    </div>
                </div>

                <!-- Terms -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">Terms of Service</h3>
                    </div>
                    <div class="card-body">
                        <textarea name="terms" rows="6" class="form-control"><?php echo e($settings['terms']); ?></textarea>
                    </div>
                </div>

                <!-- Privacy -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">Privacy Policy</h3>
                    </div>
                    <div class="card-body">
                        <textarea name="privacy" rows="6" class="form-control"><?php echo e($settings['privacy']); ?></textarea>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <!-- FAQ -->
                <div class="card card-info card-outline">
                    <div class="card-header">
                        <h3 class="card-title">FAQ</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-sm btn-info" onclick="addFaq()">
                                <i class="fas fa-plus"></i> Add FAQ
                            </button>
                        </div>
                    </div>
                    <div class="card-body" id="faqContainer">
                        <?php $__empty_1 = true; $__currentLoopData = $settings['faq']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="faq-item border rounded p-3 mb-3">
                                <div class="form-group">
                                    <label>Question</label>
                                    <input type="text" name="faq[<?php echo e($index); ?>][question]" 
                                           class="form-control" value="<?php echo e($faq['question']); ?>">
                                </div>
                                <div class="form-group mb-0">
                                    <label>Answer</label>
                                    <textarea name="faq[<?php echo e($index); ?>][answer]" rows="2" 
                                              class="form-control"><?php echo e($faq['answer']); ?></textarea>
                                </div>
                                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.faq-item').remove()">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-muted text-center">No FAQs yet. Click "Add FAQ" to create one.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Testimonials -->
                <div class="card card-success card-outline">
                    <div class="card-header">
                        <h3 class="card-title">Testimonials</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-sm btn-success" onclick="addTestimonial()">
                                <i class="fas fa-plus"></i> Add
                            </button>
                        </div>
                    </div>
                    <div class="card-body" id="testimonialContainer">
                        <?php $__empty_1 = true; $__currentLoopData = $settings['testimonials']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="testimonial-item border rounded p-3 mb-3">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Name</label>
                                            <input type="text" name="testimonials[<?php echo e($index); ?>][name]" 
                                                   class="form-control" value="<?php echo e($testimonial['name']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Role</label>
                                            <input type="text" name="testimonials[<?php echo e($index); ?>][role]" 
                                                   class="form-control" value="<?php echo e($testimonial['role'] ?? ''); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group mb-0">
                                    <label>Content</label>
                                    <textarea name="testimonials[<?php echo e($index); ?>][content]" rows="2" 
                                              class="form-control"><?php echo e($testimonial['content']); ?></textarea>
                                </div>
                                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.testimonial-item').remove()">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-muted text-center">No testimonials yet.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mb-4">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save mr-2"></i>Save All Settings
            </button>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    let faqIndex = <?php echo e(count($settings['faq'])); ?>;
    let testimonialIndex = <?php echo e(count($settings['testimonials'])); ?>;

    function addFaq() {
        const html = `
            <div class="faq-item border rounded p-3 mb-3">
                <div class="form-group">
                    <label>Question</label>
                    <input type="text" name="faq[${faqIndex}][question]" class="form-control" placeholder="Enter question">
                </div>
                <div class="form-group mb-0">
                    <label>Answer</label>
                    <textarea name="faq[${faqIndex}][answer]" rows="2" class="form-control" placeholder="Enter answer"></textarea>
                </div>
                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.faq-item').remove()">
                    <i class="fas fa-trash"></i> Remove
                </button>
            </div>
        `;
        document.getElementById('faqContainer').insertAdjacentHTML('beforeend', html);
        faqIndex++;
    }

    function addTestimonial() {
        const html = `
            <div class="testimonial-item border rounded p-3 mb-3">
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="testimonials[${testimonialIndex}][name]" class="form-control" placeholder="John Doe">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label>Role</label>
                            <input type="text" name="testimonials[${testimonialIndex}][role]" class="form-control" placeholder="Content Creator">
                        </div>
                    </div>
                </div>
                <div class="form-group mb-0">
                    <label>Content</label>
                    <textarea name="testimonials[${testimonialIndex}][content]" rows="2" class="form-control" placeholder="Testimonial content..."></textarea>
                </div>
                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.testimonial-item').remove()">
                    <i class="fas fa-trash"></i> Remove
                </button>
            </div>
        `;
        document.getElementById('testimonialContainer').insertAdjacentHTML('beforeend', html);
        testimonialIndex++;
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>