

<?php $__env->startSection('title', 'Schedules'); ?>
<?php $__env->startSection('page-title', 'My Schedules'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Schedules</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Schedules</h3>
            <div class="card-tools">
                <a href="<?php echo e(route('schedules.create')); ?>" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> New Schedule
                </a>
            </div>
        </div>
        <div class="card-body p-0">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Account</th>
                        <th>Mode</th>
                        <th>Interval</th>
                        <th>Progress</th>
                        <th>Status</th>
                        <th>Next Run</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <a href="<?php echo e(route('schedules.show', $schedule)); ?>">
                                    <?php echo e($schedule->name ?? 'Schedule #' . $schedule->id); ?>

                                </a>
                            </td>
                            <td>
                                <i class="<?php echo e($schedule->socialAccount->platform_icon); ?>"></i>
                                <?php echo e(Str::limit($schedule->socialAccount->platform_user_name, 20)); ?>

                            </td>
                            <td>
                                <span class="badge badge-<?php echo e($schedule->upload_mode === 'shorts' ? 'danger' : 'primary'); ?>">
                                    <?php echo e(ucfirst($schedule->upload_mode)); ?>

                                </span>
                            </td>
                            <td><?php echo e($schedule->interval_minutes); ?> min</td>
                            <td style="width: 150px;">
                                <div class="progress progress-sm">
                                    <div class="progress-bar bg-success" 
                                         style="width: <?php echo e($schedule->progress); ?>%"></div>
                                </div>
                                <small><?php echo e($schedule->videos->where('is_uploaded', true)->count()); ?>/<?php echo e($schedule->videos->count()); ?> videos</small>
                            </td>
                            <td>
                                <span class="badge <?php echo e($schedule->status_badge); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $schedule->status))); ?>

                                </span>
                            </td>
                            <td>
                                <?php if($schedule->next_run_at): ?>
                                    <?php echo e($schedule->next_run_at->format('M d, H:i')); ?>

                                <?php elseif($schedule->resume_at): ?>
                                    <small class="text-warning">
                                        Resumes <?php echo e($schedule->resume_at->diffForHumans()); ?>

                                    </small>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?php echo e(route('schedules.show', $schedule)); ?>" class="btn btn-info" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <?php if($schedule->status === 'active'): ?>
                                        <form action="<?php echo e(route('schedules.pause', $schedule)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-warning" title="Pause">
                                                <i class="fas fa-pause"></i>
                                            </button>
                                        </form>
                                    <?php elseif(in_array($schedule->status, ['paused', 'quota_limit'])): ?>
                                        <form action="<?php echo e(route('schedules.resume', $schedule)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-success" title="Resume">
                                                <i class="fas fa-play"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    <form action="<?php echo e(route('schedules.destroy', $schedule)); ?>" method="POST" class="d-inline"
                                          onsubmit="return confirm('Delete this schedule and all its videos?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center p-5">
                                <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No schedules found</p>
                                <a href="<?php echo e(route('schedules.create')); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create Your First Schedule
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($schedules->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($schedules->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views\schedules\index.blade.php ENDPATH**/ ?>