

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item active">Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Stats Boxes -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3><?php echo e($todayUploads); ?></h3>
                    <p>Today's Uploads</p>
                </div>
                <div class="icon">
                    <i class="fas fa-cloud-upload-alt"></i>
                </div>
                <a href="<?php echo e(route('schedules.index')); ?>" class="small-box-footer">
                    View Schedules <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo e($activeSchedules); ?></h3>
                    <p>Active Schedules</p>
                </div>
                <div class="icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <a href="<?php echo e(route('schedules.create')); ?>" class="small-box-footer">
                    Create New <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo e($pendingVideos); ?></h3>
                    <p>Videos in Queue</p>
                </div>
                <div class="icon">
                    <i class="fas fa-video"></i>
                </div>
                <a href="<?php echo e(route('schedules.index')); ?>" class="small-box-footer">
                    View All <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo e($usedQuota); ?>/<?php echo e($dailyLimit); ?></h3>
                    <p>Daily Quota Used</p>
                </div>
                <div class="icon">
                    <i class="fas fa-chart-pie"></i>
                </div>
                <a href="#" class="small-box-footer">
                    <?php echo e(round(($usedQuota / max($dailyLimit, 1)) * 100)); ?>% Used
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Next Upload Card -->
        <div class="col-md-4">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-clock mr-2"></i>Next Upload</h3>
                </div>
                <div class="card-body text-center">
                    <?php if($nextUpload): ?>
                        <h2 class="mb-0" id="countdown">
                            <?php echo e($nextUpload->next_run_at->diffForHumans()); ?>

                        </h2>
                        <p class="text-muted mt-2">
                            <?php echo e($nextUpload->next_run_at->format('M d, Y H:i')); ?>

                        </p>
                        <p>
                            <span class="badge badge-<?php echo e($nextUpload->upload_mode === 'shorts' ? 'danger' : 'primary'); ?>">
                                <?php echo e(ucfirst($nextUpload->upload_mode)); ?>

                            </span>
                        </p>
                    <?php else: ?>
                        <p class="text-muted mb-0">
                            <i class="fas fa-info-circle"></i> No scheduled uploads
                        </p>
                        <a href="<?php echo e(route('schedules.create')); ?>" class="btn btn-primary mt-3">
                            Create Schedule
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Connected Accounts -->
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-plug mr-2"></i>Connected Accounts</h3>
                </div>
                <div class="card-body p-0">
                    <?php $__empty_1 = true; $__currentLoopData = Auth::user()->socialAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="p-3 border-bottom d-flex align-items-center">
                            <i class="<?php echo e($account->platform_icon); ?> fa-2x mr-3"></i>
                            <div>
                                <strong><?php echo e($account->platform_user_name); ?></strong>
                                <br>
                                <small class="text-muted"><?php echo e(ucfirst($account->platform)); ?></small>
                            </div>
                            <?php if($account->needs_reauth): ?>
                                <span class="badge badge-warning ml-auto">Needs Reauth</span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="p-3 text-center text-muted">
                            <p>No accounts connected</p>
                            <a href="<?php echo e(route('accounts.index')); ?>" class="btn btn-sm btn-primary">
                                Connect Account
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Recent Schedules -->
        <div class="col-md-8">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-calendar-alt mr-2"></i>Recent Schedules</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('schedules.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> New Schedule
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Account</th>
                                <th>Progress</th>
                                <th>Status</th>
                                <th>Next Run</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentSchedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('schedules.show', $schedule)); ?>">
                                            <?php echo e($schedule->name ?? 'Schedule #' . $schedule->id); ?>

                                        </a>
                                        <?php if($schedule->upload_mode === 'shorts'): ?>
                                            <span class="badge badge-danger">Shorts</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <i class="<?php echo e($schedule->socialAccount->platform_icon); ?>"></i>
                                        <?php echo e(Str::limit($schedule->socialAccount->platform_user_name, 15)); ?>

                                    </td>
                                    <td>
                                        <div class="progress progress-sm">
                                            <div class="progress-bar bg-success" 
                                                 style="width: <?php echo e($schedule->progress); ?>%"></div>
                                        </div>
                                        <small><?php echo e($schedule->videos->where('is_uploaded', true)->count()); ?>/<?php echo e($schedule->videos->count()); ?></small>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo e($schedule->status_badge); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $schedule->status))); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($schedule->next_run_at): ?>
                                            <?php echo e($schedule->next_run_at->diffForHumans()); ?>

                                        <?php elseif($schedule->resume_at): ?>
                                            <small class="text-warning">Resumes <?php echo e($schedule->resume_at->diffForHumans()); ?></small>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted p-4">
                                        No schedules yet. <a href="<?php echo e(route('schedules.create')); ?>">Create your first schedule</a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Recent Uploads -->
            <div class="card card-outline card-success">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-check-circle mr-2"></i>Recent Uploads</h3>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Video</th>
                                <th>Schedule</th>
                                <th>Uploaded</th>
                                <th>Link</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentUploads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(Str::limit($video->title, 30)); ?></td>
                                    <td><?php echo e($video->schedule->name ?? 'Schedule #' . $video->schedule_id); ?></td>
                                    <td><?php echo e($video->uploaded_at->diffForHumans()); ?></td>
                                    <td>
                                        <?php if($video->platform_video_id): ?>
                                            <a href="<?php echo e($video->youtube_url); ?>" target="_blank" class="btn btn-xs btn-danger">
                                                <i class="fab fa-youtube"></i> Watch
                                            </a>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted p-4">
                                        No videos uploaded yet
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ogasm\Updit\resources\views\dashboard\index.blade.php ENDPATH**/ ?>